/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChestRaftModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.RaftModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class BoatRenderer
extends EntityRenderer<Boat> {
    private final Map<Boat.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources;

    public BoatRenderer(EntityRendererProvider.Context p_234563_, boolean p_234564_) {
        super(p_234563_);
        this.shadowRadius = 0.8f;
        this.boatResources = (Map)Stream.of(Boat.Type.values()).collect(ImmutableMap.toImmutableMap(p_173938_ -> p_173938_, p_349901_ -> Pair.of((Object)BoatRenderer.getTextureLocation(p_349901_, p_234564_), this.createBoatModel(p_234563_, (Boat.Type)p_349901_, p_234564_))));
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context p_248834_, Boat.Type p_249317_, boolean p_250093_) {
        ModelLayerLocation $$3 = p_250093_ ? ModelLayers.createChestBoatModelName(p_249317_) : ModelLayers.createBoatModelName(p_249317_);
        ModelPart $$4 = p_248834_.bakeLayer($$3);
        if (p_249317_ == Boat.Type.BAMBOO) {
            return p_250093_ ? new ChestRaftModel($$4) : new RaftModel($$4);
        }
        return p_250093_ ? new ChestBoatModel($$4) : new BoatModel($$4);
    }

    private static ResourceLocation getTextureLocation(Boat.Type p_234566_, boolean p_234567_) {
        if (p_234567_) {
            return ResourceLocation.withDefaultNamespace("textures/entity/chest_boat/" + p_234566_.getName() + ".png");
        }
        return ResourceLocation.withDefaultNamespace("textures/entity/boat/" + p_234566_.getName() + ".png");
    }

    @Override
    public void render(Boat p_113929_, float p_113930_, float p_113931_, PoseStack p_113932_, MultiBufferSource p_113933_, int p_113934_) {
        float $$8;
        p_113932_.pushPose();
        p_113932_.translate(0.0f, 0.375f, 0.0f);
        p_113932_.mulPose(Axis.YP.rotationDegrees(180.0f - p_113930_));
        float $$6 = (float)p_113929_.getHurtTime() - p_113931_;
        float $$7 = p_113929_.getDamage() - p_113931_;
        if ($$7 < 0.0f) {
            $$7 = 0.0f;
        }
        if ($$6 > 0.0f) {
            p_113932_.mulPose(Axis.XP.rotationDegrees(Mth.sin($$6) * $$6 * $$7 / 10.0f * (float)p_113929_.getHurtDir()));
        }
        if (!Mth.equal($$8 = p_113929_.getBubbleAngle(p_113931_), 0.0f)) {
            p_113932_.mulPose(new Quaternionf().setAngleAxis(p_113929_.getBubbleAngle(p_113931_) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<Boat>> $$9 = this.boatResources.get(p_113929_.getVariant());
        ResourceLocation $$10 = (ResourceLocation)$$9.getFirst();
        ListModel $$11 = (ListModel)$$9.getSecond();
        p_113932_.scale(-1.0f, -1.0f, 1.0f);
        p_113932_.mulPose(Axis.YP.rotationDegrees(90.0f));
        $$11.setupAnim(p_113929_, p_113931_, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer $$12 = p_113933_.getBuffer($$11.renderType($$10));
        $$11.renderToBuffer(p_113932_, $$12, p_113934_, OverlayTexture.NO_OVERLAY);
        if (!p_113929_.isUnderWater()) {
            VertexConsumer $$13 = p_113933_.getBuffer(RenderType.waterMask());
            if ($$11 instanceof WaterPatchModel) {
                WaterPatchModel $$14 = (WaterPatchModel)((Object)$$11);
                $$14.waterPatch().render(p_113932_, $$13, p_113934_, OverlayTexture.NO_OVERLAY);
            }
        }
        p_113932_.popPose();
        super.render(p_113929_, p_113930_, p_113931_, p_113932_, p_113933_, p_113934_);
    }

    @Override
    public ResourceLocation getTextureLocation(Boat p_113927_) {
        return (ResourceLocation)this.boatResources.get(p_113927_.getVariant()).getFirst();
    }
}

